
Date.prototype.format = function (f) {
    if (!this.valueOf()) return " ";

    var weekName = ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"];
    var d = this;

    return f.replace(/(yyyy|yy|MM|dd|E|hh|mm|ss|ms|a\/p)/gi, function ($1) {
        switch ($1) {
            case "yyyy": return d.getFullYear();
            case "yy": return (d.getFullYear() % 1000).zf(2);
            case "MM": return (d.getMonth() + 1).zf(2);
            case "dd": return d.getDate().zf(2);
            case "E": return weekName[d.getDay()];
            case "HH": return d.getHours().zf(2);
            case "hh": return ((h = d.getHours() % 12) ? h : 12).zf(2);
            case "mm": return d.getMinutes().zf(2);
            case "ss": return d.getSeconds().zf(2);
            case "ms": return d.getMilliseconds().zf(3);
            case "a/p": return d.getHours() < 12 ? "AM" : "PM";
            default: return $1;
        }
    });
};


Date.parseDate = function (f, txtvalue) {
    if (!this.valueOf()) return " ";
    if (f.length > txtvalue.length) return " ";

    var yyyy = 1970;
    var MM = 0;
    var dd = 1;
    var hh = 0;
    var mm = 0;
    var ss = 0;
    var ms = 0;

    var ongmt = false;
    var gmt = 0;

    f.replace(/(yyyy|yy|MM|dd|E|hh|mm|ss|ms|ggg|ggggg|a\/p)/gi, function ($1) {
        var start = f.indexOf($1);
        var value = txtvalue.substr(start, ($1).length);

        switch ($1) {
            case "yyyy": {
                yyyy = Number(value);
            } break;
            case "yy": {
                yyyy = Number(value) + 2000;
            } break;
            case "MM": {
                MM = Number(value) - 1;
            } break;
            case "dd": {
                dd = Number(value);
            } break;
            case "E": break;
            case "HH": {
                hh = Number(value);
            } break;
            case "hh": {
                hh = Number(value);
            } break;
            case "mm": {
                mm = Number(value);
            } break;
            case "ss": {
                ss = Number(value);
            } break;
            case "ms": {
                ms = Number(value);
            } break;
            case "ggg":
                {
                    ongmt = true;
                    if ("+" == value.substr(0, 1)) {
                        gmt = Number(value.substr(1, 2)) * 60;
                    } else if ("-" == value.substr(0, 1)) {
                        gmt = -1 *  Number(value.substr(1, 2)) * 60;
                    } else {
                        gmt = Number(value) * 60;
                    }
                } break;
            case "ggggg": {
                ongmt = true;
                if ("+" == value.substr(0, 1)) {
                    h = Math.floor(Number(value.substr(1,4)) / 100);
                    m = Number(value.substr(1, 4)) % 100;
                    gmt = h * 60 + m;
                } else if ("-" == value.substr(0, 1)) {
                    h = Math.floor(Number(value.substr(1, 4)) / 100);
                    m = Number(value.substr(1, 4)) % 100;
                    gmt = -1 * h * 60 + m;
                } else {
                    h = Math.floor(Number(value) / 100);
                    m = Number(value) % 100;
                    gmt = h * 60 + m;
                }
            } break;
        }
        return $1;
    });
    d = new Date();
    if (false == ongmt) {
        d.setFullYear(yyyy, MM, dd);
        d.setHours(hh, mm, ss, ms);
    } else {
        d.setUTCFullYear(yyyy, MM, dd);
        d.setUTCHours(hh, mm, ss, ms);
        d.setTime(d.getTime() + -1 * gmt * 60 * 1000);
    }
    return d;
};


Date.prototype.format2 = function(f) {
    if (!this.valueOf()) return " ";
 
    var weekName = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    var d = this;
     
    return f.replace(/(yyyy|yy|MM|dd|E|hh|mm|ss|a\/p)/gi, function($1) {
        switch ($1) {
            case "yyyy": return d.getFullYear();
            case "yy": return (d.getFullYear() % 1000).zf(2);
            case "MM": return (d.getMonth() + 1).zf(2);
            case "dd": return d.getDate().zf(2);
            case "E": return weekName[d.getDay()];
            case "HH": return d.getHours().zf(2);
            case "hh": return ((h = d.getHours() % 12) ? h : 12).zf(2);
            case "mm": return d.getMinutes().zf(2);
            case "ss": return d.getSeconds().zf(2);
            case "a/p": return d.getHours() < 12 ? "am" : "pm";
            default: return $1;
        }
    });
};
 
String.prototype.string = function(len) {
	var s = '', i = 0; 
	while (i++ < len) { 
		s += this;
	}
	return s;
};
String.prototype.zf = function(len) {
	return "0".string(len - this.length) + this;
};
Number.prototype.zf = function(len) {
	return this.toString().zf(len);
};

